import json
from agently import Agently

Agently.set_settings(
    "OpenAICompatible",
    {
        "base_url": "http://localhost:11434/v1",
        "model": "qwen2.5:7b",
        "model_type": "chat",
    },
).set_settings("request_options", {"temperature": 0.2}).set_settings("debug", False)

agent = Agently.create_agent()
agent.enable_session_memo(chars=800, messages=6, every_n_turns=1)
assert agent.session is not None

agent.system("你是产品顾问，回答简短，并记住用户偏好。")

reply_1 = agent.input(
    "我叫小航，正在做一款 AI 写作工具，目标用户是学生。给我 2 条建议。"
).get_text()
print("TURN1_REPLY:", reply_1)
print("TURN1_MEMO:", json.dumps(agent.session.memo, ensure_ascii=False, indent=2))

agent.info({"memo": agent.session.memo})
reply_2 = agent.input("我们预算不高，应该先做哪一个功能？").get_text()
print("TURN2_REPLY:", reply_2)
print("TURN2_MEMO:", json.dumps(agent.session.memo, ensure_ascii=False, indent=2))
