---
title: 模型输出控制概览
---

# 模型输出控制概览

当结构化结果需要进入业务系统时，我们通常希望字段稳定、结构可验证，并且在模型切换或上下文变长时依然可靠。Agently v4 通过 Agently Output Format、`ensure_keys` 与 Instant 结构化流式解析，把输出从“文本猜测”变成“可约束的结构结果”。在实际工程中，即使是 qwen2.5:7b 这样的小参数量模型，也能以超过 99% 的成功率完成输出控制；结合 `ensure_keys` 后几乎不可能失败。

常见场景包括：需要稳定字段的业务输出（表单、工单、评审、摘要）、多步流程中字段存在依赖、流式生成过程的结构化消费，以及降低模型差异带来的输出抖动。

## 能力地图

- [Agently Output Format 语法](/output-control/format)
- [`ensure_keys` 关键字段保障](/output-control/ensure-keys)
- [输出顺序与依赖控制](/output-control/order-and-deps)
- [Instant 结构化流式解析](/output-control/instant-streaming)

```mermaid
flowchart LR
  F[Agently Output Format] --> E[ensure_keys]
  E --> O[输出顺序与依赖控制]
  O --> S[Instant 结构化流式解析]
```

## 最短路径

```python
from agently import Agently

agent = Agently.create_agent()

result = (
  agent
  .input("为 Agently 写一句定位")
  .output({ "定位": ("str", "一句话定位") })
  .start()
)

print(result["定位"])
```

接下来按章节逐步扩展控制能力。
