---
title: ensure_keys 关键字段保障
---

# ensure_keys 关键字段保障

当关键字段偶发缺失时，我们通常希望结果仍然完整可用。`ensure_keys` 通过自动重试确保关键字段出现，从而提升结构化输出的稳定性。

## 标记关键字段

```python
from agently import Agently

agent = Agently.create_agent()

result = (
  agent
  .input("解释递归，并给出练习题")
  .output({
    "解释": (str, "概念解释"),
    "练习题": [
      {
        "题目": (str, "练习题问题"),
        "答案": (str, "参考答案")
      }
    ]
  })
  .start(
    ensure_keys=["练习题[*].题目", "练习题[*].答案"],
  )
)
```

## 控制路径风格

`ensure_keys` 默认使用 `dot` 路径，也支持 `slash`。

```python
.start(
  ensure_keys=["练习题[*].题目", "练习题[*].答案"],
  key_style="dot",
)
```

## 控制重试与失败策略

```python
.start(
  ensure_keys=["练习题[*].题目", "练习题[*].答案"],
  max_retries=2,
  raise_ensure_failure=False,
)
```

推荐策略：

- 对关键业务字段开启 `ensure_keys`
- 将 `max_retries` 控制在 1～3 次
- 需要“尽量返回结果”时把 `raise_ensure_failure` 设为 `False`

下一步：输出顺序如何影响稳定性。
