---
title: Agently 文档
---

<div class="doc-hero">
  <style>
    .doc-hero {
      position: relative;
    }
    .doc-hero__cta {
      justify-content: flex-end;
    }
    .qr-wrap {
      display: inline-flex;
      align-items: center;
    }
    .qr-popover {
      top: calc(100% + 8px);
      right: 0;
    }
  </style>
  <div class="doc-hero__name"><span class="brand-word">Agently</span></div>
  <p class="doc-hero__tagline">把模型输出变成可验证接口，把多步 Agent 行为变成可编排系统。</p>
  <div class="doc-hero__cta">
    <span class="doc-hero__cta-label">加入微信讨论社群</span>
    <span class="qr-wrap">
      <a class="doc-hero__cta-btn" href="https://doc.weixin.qq.com/forms/AIoA8gcHAFMAScAhgZQABIlW6tV3l7QQf">加入微信社群</a>
      <span class="qr-popover" aria-hidden="true">
        <span class="qr-popover__inner">
          <img src="./assets/qr_code.png" alt="微信社群二维码" />
          <span class="qr-popover__caption">扫码申请加入</span>
        </span>
      </span>
    </span>
  </div>
</div>

<div class="home-cards">
  <article class="VPFeature home-card">
    <h3>快速开始</h3>
    <p>5 分钟跑通模型设置、结构化输出与 Instant。</p>
    <a href="/quickstart">进入</a>
  </article>
  <article class="VPFeature home-card">
    <h3>模型设置</h3>
    <p>OpenAICompatible 配置与常见模型接入。</p>
    <a href="/model-settings">进入</a>
  </article>
  <article class="VPFeature home-card">
    <h3>模型输出控制</h3>
    <p>Agently Output Format、ensure_keys 与 Instant 结构化流式解析</p>
    <a href="/output-control/overview">进入</a>
  </article>
  <article class="VPFeature home-card">
    <h3>模型返回结果</h3>
    <p>统一获取文本、结构化数据、元信息与事件流</p>
    <a href="/model-response/overview">进入</a>
  </article>
  <article class="VPFeature home-card">
    <h3>Prompt 管理</h3>
    <p>分层 Prompt、快捷语法、配置化与变量映射</p>
    <a href="/prompt-management/overview">进入</a>
  </article>
  <article class="VPFeature home-card">
    <h3>TriggerFlow 事件编排</h3>
    <p>when‑emit 信号机制，适合复杂信号系统</p>
    <a href="/triggerflow/overview">进入</a>
  </article>
  <article class="VPFeature home-card">
    <h3>Agent 扩展能力</h3>
    <p>工具调用、MCP、auto_func、KeyWaiter、Session/Memo</p>
    <a href="/agent-extensions/tools">进入</a>
  </article>
  <article class="VPFeature home-card">
    <h3>场景实战案例</h3>
    <p>PRD→测试用例、问卷对话、知识库问答</p>
    <a href="/case-studies/overview">进入</a>
  </article>
  <article class="VPFeature home-card">
    <h3>Coding Agent 使用</h3>
    <p>面向 Codex / Claude Code 的指令与文档包</p>
    <a href="/agent-docs">查看说明</a>
  </article>
</div>
