from agently import Agently

Agently.set_settings(
    "OpenAICompatible",
    {
        "base_url": "http://localhost:11434/v1",
        "model": "qwen2.5:7b",
        "model_type": "chat",
    },
).set_settings("request_options", {"temperature": 0.2}).set_settings("debug", False)

agent = Agently.create_agent()

(
    agent.system(
        "你是合规预审助手，先给出风险，再给出处理建议。"
    )
    .input(
        "我要在官网放一个‘七天包退’的宣传页，文案包含："
        "‘100% 保本、无任何风险’。帮我判断风险并给出建议。"
    )
    .output(
        {
            "risk": (str, "主要合规风险"),
            "decision": (str, "处理建议"),
            "rewrite": (str, "替代文案"),
        }
    )
    .when_key("risk", lambda v: print("RISK:", v))
    .when_key("decision", lambda v: print("DECISION:", v))
    .when_key("rewrite", lambda v: print("REWRITE:", v))
    .start_waiter()
)
