---
title: Session & Memo 快速开始
---

# Session & Memo 快速开始

本页给你最短路径：从“只记录对话”到“可用 memo 的长对话”。

## 1. Quick Session（只记录，不截断）

```python
from agently import Agently

agent = Agently.create_agent()
agent.enable_quick_session()

agent.input("Hello").get_text()
agent.input("Remember I like concise answers").get_text()

print(agent.session.full_chat_history)
agent.disable_quick_session()
```

> 适合：只想保留历史，不想做任何裁剪或 memo。

## 2. Lite 模式（可控上下文）

```python
agent = Agently.create_agent()

# 只保留最近的上下文窗口
agent.enable_session_lite(chars=12000, messages=8, every_n_turns=4)

agent.input("... ").get_text()
```

## 3. Memo 模式（长对话推荐）

```python
from agently import Agently
from agently.core import Session

agent = Agently.create_agent()

session = Session(agent=agent).configure(
    mode="memo",
    limit={"chars": 6000, "messages": 12},
    every_n_turns=2,
)

agent.attach_session(session)
agent.input("I am Alex, based in PST.").get_text()
agent.input("I prefer JSON responses.").get_text()

print(agent.session.memo)
```

## 4. 独立使用 Session（不依赖 Agent）

```python
from agently.core import Session

session = Session().use_lite(chars=2000)

session.append_message({"role": "user", "content": "Hello"})
session.append_message({"role": "assistant", "content": "Hi"})

session.resize()
print(session.current_chat_history)
```

## 5. 下一步

- [核心概念](/agent-extensions/session-memo/concepts)
- [Memo 更新](/agent-extensions/session-memo/memo)
- [Resize 与策略](/agent-extensions/session-memo/resize)
